using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

//Dodana dla ImageFormat
using System.Drawing.Imaging;

//Dodana dla Registry
using Microsoft.Win32; //platform dependent

//Dodana dla Directory
using System.IO;

namespace Oko
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem14;
		private System.Windows.Forms.MenuItem menuItem15;
		private System.Windows.Forms.MenuItem menuItem16;
		private System.Windows.Forms.MenuItem menuItem17;
		private System.Windows.Forms.MenuItem menuItem18;
		private System.Windows.Forms.MenuItem menuItem19;
		public Oko_Katalogi oknoKatalogi=null;
		public Oko_Koszyk oknoKoszyk=null;
		private System.Windows.Forms.MenuItem menuItem20;
		private System.Windows.Forms.MenuItem menuItem21;
		private System.Windows.Forms.MenuItem menuItem22;
		private System.Windows.Forms.MenuItem menuItem23;
		private static string[] _args=null;
		private System.Windows.Forms.ContextMenu contextMenu1;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			//Przygotowania dodatkowego okna Oko - Katalogi
			oknoKatalogi=new Oko_Katalogi();
			oknoKatalogi.oknoGlowne=this;
			oknoKatalogi.Show();

			//Przygotowania dodatkowego okna Oko - Koszyk
			oknoKoszyk=new Oko_Koszyk();
			oknoKoszyk.oknoGlowne=this;
			oknoKoszyk.Show();

			//Ustalanie wlasciciela okien dodatkowych
			this.AddOwnedForm(oknoKatalogi);
			this.AddOwnedForm(oknoKoszyk);

			//Parametry z linii polecen
			if (_args!=null)
				{
				string katalog=null;
				ArrayList listaPlikow=new ArrayList();
				foreach (string argv in _args)
					{
					string argv_pelny=Path.GetFullPath(argv);
					if (katalog==null && Directory.Exists(argv_pelny)) katalog=argv_pelny;
					if (File.Exists(argv)) listaPlikow.Add(argv);
					}
				if (katalog!=null) oknoKatalogi.fileListBox1.DirectoryPath=katalog;
				if (listaPlikow.Count>0)
					{
					oknoKoszyk.listBox1.Items.AddRange(listaPlikow.ToArray());
					oknoKoszyk.listBox1.SelectedIndex=0;
					}
				}

			//Zawartosc menu kontekstowego
			MenuItem[] zawartoscMenuObraz=new MenuItem[menuItem6.MenuItems.Count];
			menuItem6.CloneMenu().MenuItems.CopyTo(zawartoscMenuObraz,0);
			contextMenu1.MenuItems.AddRange(zawartoscMenuObraz);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WinForm));
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.panel1 = new System.Windows.Forms.Panel();
			this.button3 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.button1 = new System.Windows.Forms.Button();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem17 = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.menuItem13 = new System.Windows.Forms.MenuItem();
			this.menuItem14 = new System.Windows.Forms.MenuItem();
			this.menuItem15 = new System.Windows.Forms.MenuItem();
			this.menuItem16 = new System.Windows.Forms.MenuItem();
			this.menuItem18 = new System.Windows.Forms.MenuItem();
			this.menuItem19 = new System.Windows.Forms.MenuItem();
			this.menuItem20 = new System.Windows.Forms.MenuItem();
			this.menuItem21 = new System.Windows.Forms.MenuItem();
			this.menuItem22 = new System.Windows.Forms.MenuItem();
			this.menuItem23 = new System.Windows.Forms.MenuItem();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// pictureBox1
			// 
			this.pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.pictureBox1.ContextMenu = this.contextMenu1;
			this.pictureBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pictureBox1.Location = new System.Drawing.Point(0, 0);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(292, 214);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 246);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(292, 22);
			this.statusBar1.TabIndex = 0;
			this.statusBar1.Text = "< Brak obrazu >";
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.button3);
			this.panel1.Controls.Add(this.button2);
			this.panel1.Controls.Add(this.button1);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel1.Location = new System.Drawing.Point(0, 214);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(292, 32);
			this.panel1.TabIndex = 4;
			// 
			// button3
			// 
			this.button3.Dock = System.Windows.Forms.DockStyle.Fill;
			this.button3.Enabled = false;
			this.button3.Location = new System.Drawing.Point(75, 0);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(145, 32);
			this.button3.TabIndex = 1;
			this.button3.Text = "Zapisz jako...";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button2
			// 
			this.button2.Dock = System.Windows.Forms.DockStyle.Right;
			this.button2.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(238)));
			this.button2.Location = new System.Drawing.Point(220, 0);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(72, 32);
			this.button2.TabIndex = 2;
			this.button2.Text = "Zamknij";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button1
			// 
			this.button1.Dock = System.Windows.Forms.DockStyle.Left;
			this.button1.Location = new System.Drawing.Point(0, 0);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(75, 32);
			this.button1.TabIndex = 0;
			this.button1.Text = "Otwrz...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "Wszystkie pliki (*.*)|*.*|Pliki JPEG (*.jpg)|*.jpg|Pliki GIF (*.gi" +  
				"f)|*.gif|Pliki PNG (*.png)|*.png|Pliki BMP (*.bmp)|*.bmp";
			this.openFileDialog1.InitialDirectory = ".";
			this.openFileDialog1.Title = "Wska plik graficzny";
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.Filter = "Plik JPEG (*.jpg)|*.jpg|Plik GIF (*.gif)|*.gif|Plik PNG (*.png)|*." +  
				"png|Plik TIFF (*.tif)|*.tif|Plik BMP (*.bmp)|*.bmp|Plik WMF (*.wm" +  
				"f)|*.wmf|Plik EMF (*.emf)|*.emf";
			this.saveFileDialog1.InitialDirectory = ".";
			this.saveFileDialog1.Title = "Zapisz obraz do pliku";
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem6,
						this.menuItem13});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem2,
						this.menuItem3,
						this.menuItem4,
						this.menuItem5});
			this.menuItem1.Text = "Plik";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
			this.menuItem2.Text = "Otwrz...";
			this.menuItem2.Click += new System.EventHandler(this.button1_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
			this.menuItem3.Text = "Zapisz jako...";
			this.menuItem3.Click += new System.EventHandler(this.button3_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.Text = "-";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 3;
			this.menuItem5.Shortcut = System.Windows.Forms.Shortcut.AltF4;
			this.menuItem5.Text = "Zamknij";
			this.menuItem5.Click += new System.EventHandler(this.button2_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem7,
						this.menuItem8,
						this.menuItem17,
						this.menuItem9,
						this.menuItem10,
						this.menuItem11,
						this.menuItem12});
			this.menuItem6.Text = "Obraz";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 0;
			this.menuItem7.Text = "Powiksz";
			this.menuItem7.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 1;
			this.menuItem8.Text = "Pomniejsz";
			this.menuItem8.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// menuItem17
			// 
			this.menuItem17.Index = 2;
			this.menuItem17.Text = "Do penego ekranu";
			this.menuItem17.Click += new System.EventHandler(this.menuItem17_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 3;
			this.menuItem9.Text = "Oryginalny rozmiar";
			this.menuItem9.Click += new System.EventHandler(this.menuItem9_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 4;
			this.menuItem10.Text = "-";
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 5;
			this.menuItem11.Text = "Obrt";
			this.menuItem11.Click += new System.EventHandler(this.menuItem11_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 6;
			this.menuItem12.Text = "Odbicie";
			this.menuItem12.Click += new System.EventHandler(this.menuItem12_Click);
			// 
			// menuItem13
			// 
			this.menuItem13.Index = 2;
			this.menuItem13.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem14,
						this.menuItem15,
						this.menuItem16,
						this.menuItem18});
			this.menuItem13.Text = "Widok";
			// 
			// menuItem14
			// 
			this.menuItem14.Index = 0;
			this.menuItem14.Text = "Przyciski";
			this.menuItem14.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuItem15
			// 
			this.menuItem15.Checked = true;
			this.menuItem15.Index = 1;
			this.menuItem15.Text = "Pasek stanu";
			this.menuItem15.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuItem16
			// 
			this.menuItem16.Index = 2;
			this.menuItem16.Text = "Ukryj menu";
			this.menuItem16.Click += new System.EventHandler(this.menuItem16_Click);
			// 
			// menuItem18
			// 
			this.menuItem18.Index = 3;
			this.menuItem18.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem19,
						this.menuItem20,
						this.menuItem21,
						this.menuItem22,
						this.menuItem23});
			this.menuItem18.Text = "Okna";
			this.menuItem18.Popup += new System.EventHandler(this.menuItem18_Popup);
			// 
			// menuItem19
			// 
			this.menuItem19.Checked = true;
			this.menuItem19.Index = 0;
			this.menuItem19.Text = "Katalogi";
			this.menuItem19.Click += new System.EventHandler(this.menuItem19_Click);
			// 
			// menuItem20
			// 
			this.menuItem20.Checked = true;
			this.menuItem20.Index = 1;
			this.menuItem20.Text = "Koszyk";
			this.menuItem20.Click += new System.EventHandler(this.menuItem20_Click);
			// 
			// menuItem21
			// 
			this.menuItem21.Index = 2;
			this.menuItem21.Text = "-";
			// 
			// menuItem22
			// 
			this.menuItem22.Index = 3;
			this.menuItem22.Text = "Ukryj wszystkie";
			this.menuItem22.Click += new System.EventHandler(this.menuItem22_Click);
			// 
			// menuItem23
			// 
			this.menuItem23.Index = 4;
			this.menuItem23.Text = "Poka wszystkie";
			this.menuItem23.Click += new System.EventHandler(this.menuItem23_Click);
			// 
			// WinForm
			// 
			this.AllowDrop = true;
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 268);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.statusBar1);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.KeyPreview = true;
			this.Location = new System.Drawing.Point(100, 100);
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(250, 150);
			this.Name = "WinForm";
			this.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "Oko - Przgldarka obrazw";
			this.Resize += new System.EventHandler(this.WinForm_Resize);
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.WinForm_KeyPress);
			this.Load += new System.EventHandler(this.WinForm_Load);
			this.DragOver += new System.Windows.Forms.DragEventHandler(this.WinForm_DragOver);
			this.DragDrop += new System.Windows.Forms.DragEventHandler(this.WinForm_DragDrop);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			try
			{
				_args=args;
				Application.Run(new WinForm());
			}
			catch(Exception e)
			{
				MessageBox.Show("Bd aplikacji Oko. Aplikacja zostanie zamknita\n"+e.Message);
			}
		}

		private void WinForm_Resize(object sender, System.EventArgs e)
		{
			int szerokoscPrzycisku=panel1.ClientSize.Width/3;
			button1.Width=szerokoscPrzycisku;
			button2.Width=szerokoscPrzycisku;
			button3.Width=szerokoscPrzycisku;
			//if (Height<5*panel1.Height) Height=5*panel1.Height;
		}

		private void WinForm_Load(object sender, System.EventArgs e)
		{
			WinForm_Resize(null,null);
			menuItem14_Click(null,null);
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			//Close();
			Application.Exit();
		}

		public bool wczytajObrazZPliku(string nazwaPliku,bool komunikatBledu)
		{
			try
				{
				pictureBox1.Image=Image.FromFile(nazwaPliku);
				statusBar1.Text=nazwaPliku;
				button3.Enabled=true;
				menuItem9_Click(null,null);
				return true;
				}
			catch
				{
				if (komunikatBledu)
					MessageBox.Show("Nieznany format pliku graficznego "+nazwaPliku,
									"Oko - Bd przy wczytywaniu obrazu z pliku",
									MessageBoxButtons.OK,
									MessageBoxIcon.Exclamation);
				return false;
				}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			string sciezkaDoMojeObrazy=pobierzSciezkeDoMojeObrazy();
			if (sciezkaDoMojeObrazy!=null) openFileDialog1.InitialDirectory=sciezkaDoMojeObrazy;

			if (openFileDialog1.ShowDialog()==DialogResult.OK)
				{
				string nazwaPliku=openFileDialog1.FileName;
				wczytajObrazZPliku(nazwaPliku,true);
				}
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			//Proba odczytu sciezki do pliku z wczytanym obrazem
			string nazwaPliku=openFileDialog1.FileName;
			if (nazwaPliku.Length>0)
				saveFileDialog1.FileName=nazwaPliku.Substring(0,nazwaPliku.LastIndexOf('.'));
				else return;

			if (saveFileDialog1.ShowDialog()==DialogResult.OK)
				{
				nazwaPliku=saveFileDialog1.FileName;
				if (nazwaPliku==openFileDialog1.FileName)
					{
					MessageBox.Show("Nie mona zapisac obrazu do pliku, z ktrego jest wczytany");
					return;
					}
				ImageFormat formatPliku;
				//Plik JPEG (*.jpg)|*.jpg|
				//Plik GIF (*.gif)|*.gif|
				//Plik PNG (*.png)|*.png|
				//Plik TIFF (*.tif)|*.tif|
				//Plik BMP (*.bmp)|*.bmp|
				//Plik WMF (*.wmf)|*.wmf|
				//Plik EMF (*.emf)|*.emf
				switch(saveFileDialog1.FilterIndex)
					{
					case 1: formatPliku=ImageFormat.Jpeg; break;
					case 2: formatPliku=ImageFormat.Gif; break;
					case 3: formatPliku=ImageFormat.Png; break;
					case 4: formatPliku=ImageFormat.Tiff; break;
					case 5: formatPliku=ImageFormat.Bmp; break;
					case 6: formatPliku=ImageFormat.Wmf; break;
					case 7: formatPliku=ImageFormat.Emf; break;
					default:
						formatPliku=null;
						MessageBox.Show("To nie moliwe!");
						return;
						//break;
					}
				pictureBox1.Image.Save(nazwaPliku,formatPliku);
				}
		}

		private void WinForm_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			//MessageBox.Show(""+(double)e.KeyChar);
			if (e.KeyChar=='o' || e.KeyChar=='O') button1_Click(sender,null); //otworz
			if (e.KeyChar=='s' || e.KeyChar=='S') button3_Click(sender,null); //zapisz jako
			if (e.KeyChar==(char)27) button2_Click(sender,null); //zamknij

			if (e.KeyChar=='=' || e.KeyChar=='+') menuItem7_Click(menuItem7,null); //powieksz
			if (e.KeyChar=='-' || e.KeyChar=='_') menuItem7_Click(menuItem8,null); //pomniejsz
			if (e.KeyChar=='0') menuItem9_Click(null,null); //oryginalny rozmiar

			if (e.KeyChar=='m') this.Menu=(this.Menu==null)?mainMenu1:null;
		}

		//metoda zwracajaca sciezke do katalogu Moje obrazy
		//using Microsoft.Win32; //platform dependent
		private string pobierzSciezkeDoMojeObrazy()
		{
			const string nazwaKlucza="Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
			const string nazwaWartosci="My Pictures";
			try
				{
				RegistryKey rejestr=Registry.CurrentUser.OpenSubKey(nazwaKlucza);
				if (rejestr==null) throw new Exception("brak klucza '"+nazwaKlucza+"'");
				string sciezkaDoMojeObrazy=(string)rejestr.GetValue(nazwaWartosci);
				if (sciezkaDoMojeObrazy==null) throw new Exception("brak wartosci '"+nazwaWartosci+"'");
				rejestr.Close();
				return sciezkaDoMojeObrazy;
				}
			catch(Exception exc)
				{
				MessageBox.Show("Bd przy czytaniu rejestru: "+exc.Message+".");
				return null;
				}
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			//double wsp=1.3;
			double wsp=(sender==menuItem7)?1.3:(1/1.3);
			int roznicaSzer=this.Width-pictureBox1.Width;
			int roznicaWys=this.Height-pictureBox1.Height;
			this.Width=roznicaSzer+(int)(wsp*pictureBox1.Width);
			this.Height=roznicaWys+(int)(wsp*pictureBox1.Height);
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
			//to zadziala poprawnie tylko dla map bitowych (wektorowe zwracaja w 0.01 milimetra)
			if (pictureBox1.Image==null || pictureBox1.Image is Metafile) return;
			int roznicaSzer=this.Width-pictureBox1.Width;
			int roznicaWys=this.Height-pictureBox1.Height;
			this.Width=roznicaSzer+(int)pictureBox1.Image.PhysicalDimension.Width;
			this.Height=roznicaWys+(int)pictureBox1.Image.PhysicalDimension.Height;
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			pictureBox1.Image.RotateFlip(RotateFlipType.Rotate90FlipNone);
			int roznicaWysSzer=pictureBox1.Height-pictureBox1.Width;
			this.Width+=roznicaWysSzer;
			this.Height-=roznicaWysSzer;
		}

		private void menuItem12_Click(object sender, System.EventArgs e)
		{
			pictureBox1.Image.RotateFlip(RotateFlipType.RotateNoneFlipX);
			pictureBox1.Refresh(); //nie ma zmiany rozmiaru pictureBox1, wiec nie odswieza zawartosci
		}

		private void menuItem14_Click(object sender, System.EventArgs e)
		{
			if (sender!=null)
				{
				MenuItem miSender=(MenuItem)sender;
				miSender.Checked=!miSender.Checked;
				}

			panel1.Visible=menuItem14.Checked;
			statusBar1.Visible=menuItem15.Checked;
		}

		private void menuItem16_Click(object sender, System.EventArgs e)
		{
			this.Menu=null;
			//this.Menu=mainMenu1;
		}

		private void menuItem17_Click(object sender, System.EventArgs e)
		{
			menuItem17.Checked=!menuItem17.Checked;
			this.WindowState=menuItem17.Checked?FormWindowState.Maximized:FormWindowState.Normal;
		}
		
		private void menuItem19_Click(object sender, System.EventArgs e)
		{
			menuItem19.Checked=!menuItem19.Checked;
			this.oknoKatalogi.Visible=menuItem19.Checked;
		}

		private void menuItem20_Click(object sender, System.EventArgs e)
		{
			menuItem20.Checked=!menuItem20.Checked;
			this.oknoKoszyk.Visible=menuItem20.Checked;
		}

		private void WinForm_DragOver(object sender, System.Windows.Forms.DragEventArgs e)
		{
			e.Effect=DragDropEffects.Copy;
		}

		private void WinForm_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{
			string nazwaPliku=e.Data.GetData(DataFormats.Text).ToString();
			this.wczytajObrazZPliku(nazwaPliku,true);
		}

		private void menuItem18_Popup(object sender, System.EventArgs e)
		{
			menuItem19.Checked=oknoKatalogi.Visible;
			menuItem20.Checked=oknoKoszyk.Visible;
		}
		
		private void menuItem22_Click(object sender, System.EventArgs e)
		{
			foreach (Form okno in this.OwnedForms)
				okno.Hide();
		}

		private void menuItem23_Click(object sender, System.EventArgs e)
		{
			foreach (Form okno in this.OwnedForms)
				okno.Show();
		}
	}
}
